<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\RestAuthBundle\Model\Request\Node;

use JMS\Serializer\Annotation as Serializer;

/**
 * Steps Credentials
 *
 * @copyright  Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */
class Credentials
{
    /**
     * @Serializer\Exclude()
     * @var Factory
     */
    private $nodeFactory;

    /**
     * @Serializer\SerializedName("ServiceProvider")
     * @Serializer\Type("LifeStyle\Tools\RestAuthBundle\Model\Request\Node\ServiceProvider")
     * @var ServiceProvider
     */
    private $serviceProvider;

    /**
     * @Serializer\SerializedName("ServiceTrigger")
     * @Serializer\Type("LifeStyle\Tools\RestAuthBundle\Model\Request\Node\ServiceTrigger")
     * @var ServiceTrigger
     */
    private $serviceTrigger;

    /**
     * @Serializer\SerializedName("ServiceCountry")
     * @Serializer\Type("LifeStyle\Tools\RestAuthBundle\Model\Request\Node\ServiceCountry")
     * @var ServiceCountry
     */
    private $serviceCountry;

    /**
     * @param Factory $nodeFactory
     */
    public function __construct(Factory $nodeFactory)
    {
        $this->nodeFactory = $nodeFactory;
    }

    /**
     * @return ServiceProvider
     */
    public function serviceProvider()
    {
        return null !== $this->serviceProvider ? $this->serviceProvider : ($this->serviceProvider = $this->nodeFactory->serviceProvider());
    }

    /**
     * @return ServiceTrigger
     */
    public function serviceTrigger()
    {
        return null !== $this->serviceTrigger ? $this->serviceTrigger : ($this->serviceTrigger = $this->nodeFactory->serviceTrigger());
    }

    /**
     * @return ServiceTrigger
     */
    public function serviceCountry()
    {
        return null !== $this->serviceCountry ? $this->serviceCountry : ($this->serviceCountry = $this->nodeFactory->serviceCountry());
    }
}
