<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\RestAuthBundle\Model\Request\Node;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class ServiceTrigger
 * @package LifeStyle\Tools\RestAuthBundle\Model\Request\Node
 */
class ServiceTrigger
{
    /**
     * @Serializer\SerializedName("UserIdentifier")
     * @var string
     */
    private $userIdentifier;

    /**
     * @param string $userIdentifier
     * @return ServiceTrigger
     */
    public function setUserIdentifier($userIdentifier)
    {
        $this->userIdentifier = (string)$userIdentifier;

        return $this;
    }

    /**
     * @return string
     */
    public function getUserIdentifier()
    {
        return $this->userIdentifier;
    }
}
