<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\RestAuthBundle\Model\Request\Node;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class UserType
 * @package LifeStyle\Tools\RestAuthBundle\Model\Request\Node
 */
class UserType
{
    /**
     * @Serializer\SerializedName("Username")
     * @var string
     */
    private $username;

    /**
     * @Serializer\SerializedName("Password")
     * @var string
     */
    private $password;

    /**
     * @Serializer\SerializedName("UserIdentifier")
     * @var string
     */
    private $userIdentifier;

    /**
     * @param string $username
     * @return UserType
     */
    public function setUsername($username)
    {
        $this->username = (string)$username;

        return $this;
    }

    /**
     * @return string
     */
    public function getUsername()
    {
        return $this->username;
    }

    /**
     * @param string $password
     * @return UserType
     */
    public function setPassword($password)
    {
        $this->password = (string)$password;

        return $this;
    }

    /**
     * @return string
     */
    public function getPassword()
    {
        return $this->password;
    }

    /**
     * @param string $userIdentifier
     * @return UserType
     */
    public function setUserIdentifier($userIdentifier)
    {
        $this->userIdentifier = (string)$userIdentifier;

        return $this;
    }

    /**
     * @return string
     */
    public function getUserIdentifier()
    {
        return $this->userIdentifier;
    }
}
