<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\RestAuthBundle\Model\Response\Node;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Base
 * @package LifeStyle\Tools\RestAuthBundle\Model\Response\Node
 */
abstract class Base
{
    /**
     * @Serializer\SerializedName("Status")
     * @var string
     */
    private $status;

    /**
     * @Serializer\SerializedName("Status")
     * @Serializer\Type("array<LifeStyle\Tools\RestAuthBundle\Model\Response\Node\Error")
     * @var Error[]
     */
    private $errors = [];

    /**
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @return Error[]
     */
    public function getErrors()
    {
        return $this->errors;
    }
}
