<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\RestAuthBundle\Model\Response\UserIdentifier;

use JMS\Serializer\Annotation as Serializer;
use LifeStyle\Tools\RestAuthBundle\Model\Response\Node;

/**
 * Class Get
 * @package LifeStyle\Tools\RestAuthBundle\Model\Response\UserIdentifier
 */
class Get
{
    /**
     * @Serializer\SerializedName("Status")
     * @Serializer\Type("string")
     * @var string
     */
    private $status;

    /**
     * @Serializer\SerializedName("UserType")
     * @Serializer\Type("LifeStyle\Tools\RestAuthBundle\Model\Response\Node\UserType")
     * @var Node\UserType
     */
    private $userType;

    /**
     * @Serializer\SerializedName("Errors")
     * @Serializer\Type("array<LifeStyle\Tools\RestAuthBundle\Model\Response\Node\Error>")
     * @var Node\Error[]
     */
    private $errors;

    /**
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @return Node\UserType
     */
    public function getUserType()
    {
        return $this->userType;
    }

    /**
     * @return Node\Error[]
     */
    public function getErrors()
    {
        return $this->errors;
    }
}
