<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\RestErrorBundle\Api\Error;

use Symfony\Bridge\Monolog\Logger;

/**
 * Class Factory
 * @package LifeStyle\Tools\RestErrorBundle\Api\Error
 */
class Factory
{
    /**
     * @var array
     */
    protected $factorySetter;

    /**
     * @var Logger
     */
    protected $log;

    /**
     * @var string
     */
    protected $trackId;

    /**
     * Factory constructor.
     * @param Logger $log
     * @param string $trackId
     */
    public function __construct(Logger $log, $trackId)
    {
        $this->log = $log;
        $this->trackId = $trackId;
    }

    /**
     * @return Errors\Index
     */
    public function errors()
    {
        if (!isset($this->factorySetter[__FUNCTION__])) {
            $this->factorySetter[__FUNCTION__] = new Errors\Index($this->log, $this->trackId);
        }
        return $this->factorySetter[__FUNCTION__];
    }

    /**
     * @return Response\Index
     */
    public function response()
    {
        if (!isset($this->factorySetter[__FUNCTION__])) {
            $this->factorySetter[__FUNCTION__] = new Response\Index();
        }
        return $this->factorySetter[__FUNCTION__];
    }

    /**
     * @return View\Index
     */
    public function view()
    {
        if (!isset($this->factorySetter[__FUNCTION__])) {
            $this->factorySetter[__FUNCTION__] = new View\Index();
        }
        return $this->factorySetter[__FUNCTION__];
    }

    /**
     * @return Helper\Index
     */
    public function helper()
    {
        if (!isset($this->factorySetter[__FUNCTION__])) {
            $this->factorySetter[__FUNCTION__] = new Helper\Index();
        }
        return $this->factorySetter[__FUNCTION__];
    }
}
