<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\RestErrorBundle\Api;

use Symfony\Bridge\Monolog\Logger;
use Symfony\Component\DependencyInjection\ContainerInterface as Container;
use JMS\Serializer\Serializer;

/**
 * Class Manager
 * @package LifeStyle\Tools\RestErrorBundle\Api
 */
class Manager
{
    /**
     * @var array
     */
    protected $setter;

    /**
     * @var Container
     */
    protected $container;

    /**
     * Manager constructor.
     * @param Container $container
     */
    public function __construct(Container $container)
    {
        $this->container = $container;
    }

    /**
     * @return Logger
     */
    public function logger()
    {
        return $this->container->get('logger');
    }

    /**
     * @return Error\Factory
     */
    public function error()
    {
        if (!isset($this->setter[__FUNCTION__])) {
            $this->setter[__FUNCTION__] = new Error\Factory($this->logger(), $this->getTrackId());
        }
        return $this->setter[__FUNCTION__];
    }

    /**
     * @return \JMS\Serializer\Serializer
     */
    public function serializer()
    {
        return $this->container->get('jms_serializer');
    }

    /**
     * @return string
     */
    public function getTrackId()
    {
        return $this->container->get('lifestyle.elk.monolog.processor.trackid')->getTrackId();
    }
}
