<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Api\Client\Helper;

/**
 * Class Options
 * @package Sso\RestBundle\Api\Client\Helper
 */
class Options
{
    /**
     * @param integer $apiVersion
     * @param string $controllerName
     * @param string $actionName
     * @param string $body
     * @return array
     */
    public function getOptions($apiVersion, $controllerName, $actionName, $body)
    {
        return [
            'headers' => [
                'API-VERSION' => $apiVersion,
                'API-CONTROLLER' => $controllerName,
                'API-ACTION' => $actionName,
                'Content-Type' => 'text/xml; charset=UTF-8',
            ],
            'body' => $body
        ];
    }
}
