<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Api\Configuration;

use Symfony\Component\DependencyInjection\ContainerInterface as Container;

/**
 * Class Factory
 * @package Sso\RestBundle\Api\Configuration
 */
class Factory
{
    /**
     * @var array
     */
    protected $setter;

    /**
     * @var Container
     */
    protected $container;

    /**
     * @param Container $container
     */
    public function __construct(Container $container)
    {
        $this->container = $container;
    }

    /**
     * @return ObjectWebservice\Index
     */
    public function objectWs()
    {
        if (!isset($this->setter[__FUNCTION__])) {
            $this->setter[__FUNCTION__] = new ObjectWebservice\Index($this->container);
        }
        return $this->setter[__FUNCTION__];
    }

    /**
     * @return UserIdentifier\Index
     */
    public function userIdentifier()
    {
        if (!isset($this->setter[__FUNCTION__])) {
            $this->setter[__FUNCTION__] = new UserIdentifier\Index($this->container);
        }
        return $this->setter[__FUNCTION__];
    }

    /**
     * @return UserWebservice\Index
     */
    public function userWs()
    {
        if (!isset($this->setter[__FUNCTION__])) {
            $this->setter[__FUNCTION__] = new UserWebservice\Index($this->container);
        }
        return $this->setter[__FUNCTION__];
    }

    /**
     * @return ScopeConfig\Index
     */
    public function scopeConfig()
    {
        if (!isset($this->setter[__FUNCTION__])) {
            $this->setter[__FUNCTION__] = new ScopeConfig\Index($this->container);
        }
        return $this->setter[__FUNCTION__];
    }
}
