<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\Api\Configuration\UserIdentifier;

use Symfony\Component\DependencyInjection\ContainerInterface as Container;

/**
 * Class Index
 * @package Sso\RestBundle\Api\Configuration\UserIdentifier
 */
class Index
{
    /**
     * @var array
     */
    protected $setter;

    /**
     * @var Container
     */
    protected $container;

    /**
     * @var array
     */
    protected $userIdentifier;

    /**
     * @param Container $container
     */
    public function __construct(Container $container)
    {
        $this->container = $container;
        $tempArray = $this->container->getParameter('sso_rest');
        $this->userIdentifier = $tempArray['user_identifier'];
    }

    /**
     * @return string
     */
    public function getBaseUrl()
    {
        return $this->userIdentifier['base_url'];
    }

    /**
     * @return string
     */
    public function getServiceAction()
    {
        return $this->userIdentifier['action'];
    }
}
