<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Common\Type;

use JMS\Serializer\Annotation as Serializer;
use JMS\Serializer\DeserializationContext;
use JMS\Serializer\JsonDeserializationVisitor;
use JMS\Serializer\JsonSerializationVisitor;
use JMS\Serializer\XmlDeserializationVisitor;
use JMS\Serializer\XmlSerializationVisitor;

/**
 * Class ArrayStringType
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\RestBundle\ModelRest\Common\Type
 */
class ArrayStringType
{
    /**
     * @Serializer\Exclude()
     * @var array|null
     */
    private $value;

    /**
     * ArrayStringType constructor.
     * @param array|null $value
     */
    public function __construct($value)
    {
        $this->value = $value;
    }

    /**
     * @return array|null
     */
    public function getValue()
    {
        return $this->value;
    }
}
