<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Request\ObjectWs\Version1\Attribute\Add;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Attribute
 *
 * @Serializer\XmlRoot("attributes")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Request\ObjectWs\Version1\Attribute\Add
 */
class Attribute
{
    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("name")
     *
     * @var string
     */
    private $attributeName;

    /**
     * @Serializer\SerializedName("mandatory")
     * @Serializer\Type("integer")
     *
     * @var int
     */
    private $attributeMandatory;

    /**
     * @Serializer\SerializedName("possibleValues")
     * @Serializer\Type("ArrayCollection<string>")
     * @Serializer\XmlList(entry="value")
     *
     * @var mixed
     */
    private $attributePossibleValues;

    /**
     * @Serializer\SerializedName("defaultValue")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $attributeDefaultValue;

    /**
     * @Serializer\SerializedName("translatable")
     * @Serializer\Type("integer")
     *
     * @var int
     */
    private $attributeTranslatable;

    /**
     * @Serializer\SerializedName("groupId")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $attributeGroupId;

    /**
     * @return string
     */
    public function getAttributeName()
    {
        return $this->attributeName;
    }

    /**
     * @param string $attributeName
     * @return Attribute
     */
    public function setAttributeName($attributeName)
    {
        $this->attributeName = $attributeName;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getAttributeMandatory()
    {
        return $this->attributeMandatory;
    }

    /**
     * @param mixed $attributeMandatory
     * @return Attribute
     */
    public function setAttributeMandatory($attributeMandatory)
    {
        $this->attributeMandatory = $attributeMandatory;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getAttributePossibleValues()
    {
        return $this->attributePossibleValues;
    }

    /**
     * @param mixed $attributePossibleValues
     * @return Attribute
     */
    public function setAttributePossibleValues($attributePossibleValues)
    {
        $this->attributePossibleValues = $attributePossibleValues;
        return $this;
    }

    /**
     * @return string
     */
    public function getAttributeDefaultValue()
    {
        return $this->attributeDefaultValue;
    }

    /**
     * @param string $attributeDefaultValue
     * @return Attribute
     */
    public function setAttributeDefaultValue($attributeDefaultValue)
    {
        $this->attributeDefaultValue = $attributeDefaultValue;
        return $this;
    }

    /**
     * @return int
     */
    public function getAttributeTranslatable()
    {
        return $this->attributeTranslatable;
    }

    /**
     * @param int $attributeTranslatable
     * @return Attribute
     */
    public function setAttributeTranslatable($attributeTranslatable)
    {
        $this->attributeTranslatable = $attributeTranslatable;
        return $this;
    }

    /**
     * @return string
     */
    public function getAttributeGroupId()
    {
        return $this->attributeGroupId;
    }

    /**
     * @param string $attributeGroupId
     * @return Attribute
     */
    public function setAttributeGroupId($attributeGroupId)
    {
        $this->attributeGroupId = $attributeGroupId;
        return $this;
    }
}
