<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Request\ObjectWs\Version1\Attribute\Show;

use JMS\Serializer\Annotation as Serializer;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class Request
 *
 * @Serializer\XmlRoot("attribute")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Request\ObjectWs\Version1\Attribute\Show
 */
class Request
{
    /**
     * @Serializer\Type("string")
     *
     * @Assert\Length(
     *      min = 36,
     *      max = 36,
     *      minMessage = "Your id must be {{ limit }} characters long",
     *      maxMessage = "Your id must be {{ limit }} characters long"
     * )
     *
     * @var string
     */
    protected $id;

    /**
     * @Serializer\Type("integer")
     *
     * @Assert\GreaterThanOrEqual(
     *     value = 0,
     *     message = "Your offset must be greater than or equal {{ compared_value }}"
     * )
     *
     * @var int
     */
    private $offset;

    /**
     * @Serializer\Type("integer")
     *
     * @Assert\Range(
     *      min = 1,
     *      max = 1500,
     *      minMessage = "Your limit must be at least {{ limit }}.",
     *      maxMessage = "Your limit can not be bigger than {{ limit }}."
     * )
     *
     * @var int
     */
    private $limit;

    /**
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param string $id
     * @return Request
     */
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return int
     */
    public function getOffset()
    {
        return $this->offset;
    }

    /**
     * @param int $offset
     * @return Request
     */
    public function setOffset($offset)
    {
        $this->offset = $offset;
        return $this;
    }

    /**
     * @return int
     */
    public function getLimit()
    {
        return $this->limit;
    }

    /**
     * @param int $limit
     * @return Request
     */
    public function setLimit($limit)
    {
        $this->limit = $limit;
        return $this;
    }
}
