<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Request\ObjectWs\Version1\Attribute\Update;

use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;

/**
 *
 * @Serializer\XmlRoot("attributeUpdate")
 *
 * Class Request
 * @package Sso\RestBundle\ModelRest\Request\ObjectWs\Version1\Attribute\Update
 */
class Request
{
    /**
     * @Serializer\SerializedName("attributes")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Request\ObjectWs\Version1\Attribute\Update\Attribute>")
     * @Serializer\XmlList(entry="attribute")
     *
     * @var Attribute[]|ArrayCollection
     */
    private $attributes;

    /**
     * @return Attribute[]|ArrayCollection
     */
    public function getAttributes()
    {
        return $this->attributes;
    }

    /**
     * @param Attribute $attribute
     * @return Request
     */
    public function setAttribute(Attribute $attribute)
    {
        if (!$this->attributes) {
            $this->attributes = new ArrayCollection();
        }

        if (!$this->attributes->contains($attribute)) {
            $this->attributes->add($attribute);
        }

        return $this;
    }
}
