<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Request\ObjectWs\Version1\AttributeGroup\Update;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class AttributeGroup
 *
 * @Serializer\XmlRoot("attributeGroup")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Request\ObjectWs\Version1\AttributeGroup\Update
 */
class AttributeGroup
{
    /**
     * @Serializer\SerializedName("id")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $id;

    /**
     * @Serializer\SerializedName("name")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $name;

    /**
     * @Serializer\SerializedName("add")
     * @Serializer\Type("ArrayCollection<string>")
     * @Serializer\XmlList(entry="id")
     *
     * @var string[]|ArrayCollection
     */
    private $add;

    /**
     * @Serializer\SerializedName("delete")
     * @Serializer\Type("ArrayCollection<string>")
     * @Serializer\XmlList(entry="id")
     *
     * @var string[]|ArrayCollection
     */
    private $delete;

    /**
     * @Serializer\SerializedName("deleteReferences")
     * @Serializer\Type("boolean")
     *
     * @var boolean
     */
    private $deleteReferences;

    /**
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param string $id
     *
     * @return AttributeGroup
     */
    public function setId($id)
    {
        $this->id = $id;

        return $this;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     *
     * @return $this
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return string[]|ArrayCollection
     */
    public function getAdd()
    {
        return $this->add;
    }

    /**
     * @param string $id
     * @return AttributeGroup
     */
    public function setAdd($id)
    {
        if (!$this->add) {
            $this->add = new ArrayCollection();
        }

        if (!$this->add->contains($id)) {
            $this->add->add($id);
        }

        return $this;
    }

    /**
     * @return string[]|ArrayCollection
     */
    public function getDelete()
    {
        return $this->delete;
    }

    /**
     * @param string $id
     * @return AttributeGroup
     */
    public function setDelete($id)
    {
        if (!$this->delete) {
            $this->delete = new ArrayCollection();
        }

        if (!$this->delete->contains($id)) {
            $this->delete->add($id);
        }

        return $this;
    }

    /**
     * @return boolean
     */
    public function isDeleteReferences()
    {
        return $this->deleteReferences;
    }

    /**
     * @param boolean $deleteReferences
     *
     * @return AttributeGroup
     */
    public function setDeleteReferences($deleteReferences)
    {
        $this->deleteReferences = $deleteReferences;

        return $this;
    }
}
