<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Request\ObjectWs\Version1\Object\Show\Tree;

use JMS\Serializer\Annotation as Serializer;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class Request
 *
 * @Serializer\XmlRoot("object")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Request\ObjectWs\Version1\Object\Show\Tree
 */
final class Request
{
    /**
     * @Assert\Length(
     *      min = 36,
     *      max = 36,
     *      minMessage = "Your guid must be {{ limit }} characters long",
     *      maxMessage = "Your guid must be {{ limit }} characters long"
     * )
     *
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $guid;

    /**
     * @Assert\Type("string")
     * @Assert\Length(
     *      min = 1,
     *      max = 255,
     *      minMessage = "Your reference id must be at least {{ limit }} characters long",
     *      maxMessage = "Your reference id can not be bigger than {{ limit }} characters."
     * )
     *
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $referenceId;

    /**
     * @Assert\GreaterThanOrEqual(
     *     value = 0,
     *     message = "Your offset must be greater than or equal {{ compared_value }}"
     * )
     *
     * @Serializer\Type("integer")
     *
     * @var int
     */
    private $offset;

    /**
     * @Assert\Range(
     *      min = 1,
     *      max = 1500,
     *      minMessage = "Your limit must be at least {{ limit }}.",
     *      maxMessage = "Your limit can not be bigger than {{ limit }}."
     * )
     *
     * @Serializer\Type("integer")
     *
     * @var int
     */
    private $limit;

    /**
     * @param string $guid
     * @return Request
     */
    public function setGuid($guid)
    {
        $this->guid = $guid;

        return $this;
    }

    /**
     * @return string
     */
    public function getGuid()
    {
        return $this->guid;
    }

    /**
     * @return string
     */
    public function getReferenceId()
    {
        return $this->referenceId;
    }

    /**
     * @param string $referenceId
     * @return Request
     */
    public function setReferenceId($referenceId)
    {
        $this->referenceId = $referenceId;

        return $this;
    }

    /**
     * @return string
     */
    public function getOffset()
    {
        return $this->offset;
    }

    /**
     * @param string $offset
     * @return Request
     */
    public function setOffset($offset)
    {
        $this->offset = $offset;

        return $this;
    }

    /**
     * @return string
     */
    public function getLimit()
    {
        return $this->limit;
    }

    /**
     * @param string $limit
     * @return Request
     */
    public function setLimit($limit)
    {
        $this->limit = $limit;

        return $this;
    }
}
