<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Request\ObjectWs\Version1\ObjectType\Add;

use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class Request
 *
 * @Serializer\XmlRoot("objectType")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Request\ObjectWs\Version1\ObjectType\Add
 */
class Request
{
    /**
     * @Serializer\SerializedName("objectType")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Request\ObjectWs\Version1\ObjectType\Add\Item>")
     * @Serializer\XmlList(entry="item", inline=true)
     *
     * @Assert\NotNull()
     * @Assert\Valid()
     * @Assert\All({
     *     @Assert\NotBlank()
     * })
     *
     * @var Item[]|ArrayCollection
     */
    protected $items;

    /**
     * Request constructor.
     */
    public function __construct()
    {
        $this->items = new ArrayCollection();
    }

    /**
     * @return Item[]|ArrayCollection
     */
    public function getItem()
    {
        return $this->items;
    }

    /**
     * @param Item $item
     */
    public function addItem(Item $item)
    {
        $this->items[] = $item;
    }
}
