<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Request\ObjectWs\Version1\ObjectType\Update;

use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class Item
 *
 * @Serializer\XmlRoot("item")
 * @package Sso\RestBundle\ModelRest\Request\ObjectWs\Version1\ObjectType\Update
 */
class Item
{
    /**
     * Validation
     *
     * @Assert\NotBlank
     *
     * @Assert\Length(
     *      min = 36,
     *      max = 36,
     *      minMessage = "Id must be at least {{ limit }} characters long",
     *      maxMessage = "Id cannot be longer than {{ limit }} characters",
     *      exactMessage = "Id should have exactly {{ limit }} characters"
     * )
     *
     * @Serializer\Type("string")
     * @Serializer\SerializedName("id")
     *
     * @var string
     */
    private $id;

    /**
     * @Serializer\SerializedName("name")
     * @Serializer\Type("string")
     *
     * @Assert\Length(
     *      min = 3,
     *      max = 100,
     *      minMessage = "Name must be at least {{ limit }} characters long",
     *      maxMessage = "Name cannot be longer than {{ limit }} characters"
     * )
     *
     * @var string
     */
    protected $name;

    /**
     * @Serializer\SerializedName("order")
     * @Serializer\Type("integer")
     *
     * @Assert\Regex(
     *     pattern="/^[1-9]\d*$/",
     *     message="Your order must be greater than 0."
     * )
     *
     * @var int
     */
    protected $order;

    /**
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param string $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     *
     * @param string $name
     */
    public function setName($name)
    {
        $this->name = $name;
    }

    /**
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @return int
     */
    public function getOrder()
    {
        return $this->order;
    }

    /**
     * @param int $order
     */
    public function setOrder($order)
    {
        $this->order = $order;
    }
}
