<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Request\UserWs\Version1\Attribute\Add;

use JMS\Serializer\Annotation as Serializer;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class Item
 *
 * @Serializer\XmlRoot("item")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Request\UserWs\Version1\Attribute\Add
 */
class Item
{

    /**
     * @Serializer\SerializedName("groupId")
     * @Serializer\Type("string")
     *
     * @Assert\NotBlank(message = "Your group id should not be empty")
     * @Assert\Length(
     *     min = 36,
     *     max = 36,
     *     minMessage = "Your group id must be {{ limit }} characters long",
     *     maxMessage = "Your group id must be {{ limit }} characters long",
     *     exactMessage = "Your group id must be {{ limit }} characters long"
     * )
     *
     * @var string
     */
    private $attributeGroupId;

    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("name")
     *
     * @Assert\NotBlank(message = "Attribute Name should not be empty",)
     * @Assert\Length(
     *      min = 3,
     *      max = 200,
     *      minMessage = "Attribute Name must be at least {{ limit }} characters long",
     *      maxMessage = "Attribute Name cannot be longer than {{ limit }} characters",
     *      exactMessage = "Attribute Name should have exactly {{ limit }} characters"
     * )
     *
     * @var string
     */
    private $attributeName;

    /**
     * @return string
     */
    public function getAttributeGroupId()
    {
        return $this->attributeGroupId;
    }

    /**
     * @param string $attributeGroupId
     * @return Item
     */
    public function setAttributeGroupId($attributeGroupId)
    {
        $this->attributeGroupId = $attributeGroupId;
        return $this;
    }

    /**
     * @return string
     */
    public function getAttributeName()
    {
        return $this->attributeName;
    }

    /**
     * @param string $attributeName
     * @return Item
     */
    public function setAttributeName($attributeName)
    {
        $this->attributeName = $attributeName;
        return $this;
    }
}
