<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Request\UserWs\Version1\Attribute\Delete;

use JMS\Serializer\Annotation as Serializer;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class Item
 * @Serializer\XmlRoot("item")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Request\UserWs\Version1\Attribute\Delete
 */
class Item
{
    /**
     * @Serializer\SerializedName("id")
     * @Serializer\Type("string")
     *
     * @Assert\NotBlank()
     * @Assert\Length(
     *      min = 36,
     *      max = 36,
     *      minMessage = "Your id must be {{ limit }} characters long",
     *      maxMessage = "Your id must be {{ limit }} characters long"
     * )
     *
     * @var string
     */
    protected $id;

    /**
     * @Serializer\SerializedName("deleteReferences")
     * @Serializer\Type("boolean")
     *
     * @var bool
     */
    protected $deleteReferences = false;

    /**
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param string $id
     * @return Item
     */
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return boolean
     */
    public function isDeleteReferences()
    {
        return $this->deleteReferences;
    }

    /**
     * @param boolean $deleteReferences
     * @return Item
     */
    public function setDeleteReferences($deleteReferences)
    {
        $this->deleteReferences = $deleteReferences;
        return $this;
    }
}
