<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Request\UserWs\Version1\UserApplication\Add;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class UserApplication
 *
 * @Serializer\XmlRoot("UserApplication")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Request\UserWs\Version1\UserApplication\Add
 */
class UserApplication
{
    /**
     * @Serializer\SerializedName("identifier")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $identifier;

    /**
     * @Serializer\SerializedName("application")
     * @Serializer\Type("Sso\RestBundle\ModelRest\Request\UserWs\Version1\UserApplication\Add\Application")
     *
     * @var Application
     */
    private $application;

    /**
     * @return string
     */
    public function getIdentifier()
    {
        return $this->identifier;
    }

    /**
     * @param string $identifier
     * @return UserApplication
     */
    public function setIdentifier($identifier)
    {
        $this->identifier = $identifier;

        return $this;
    }

    /**
     * @return Application
     */
    public function getApplication()
    {
        return $this->application;
    }

    /**
     * @param Application $application
     * @return UserApplication
     */
    public function setApplication(Application $application)
    {
        $this->application = $application;

        return $this;
    }
}
