<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Request\UserWs\Version1\UserApplicationAttribute\Delete;

use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * @Serializer\XmlRoot("userAttributeDelete")
 *
 * Class Request
 * @package Sso\RestBundle\ModelRest\Request\UserWs\Version1\UserApplicationAttribute\Delete
 */
class Request
{
    /**
     * @Serializer\SerializedName("userAttributes")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Request\UserWs\Version1\UserApplicationAttribute\Delete\UserAttributeType>")
     * @Serializer\XmlList(entry="userAttributeType")
     *
     * @var UserAttributeType[]|ArrayCollection
     */
    private $userAttributeType;

    /**
     * Request constructor.
     */
    public function __construct()
    {
        $this->userAttributeType = new ArrayCollection();
    }

    /**
     * @return UserAttributeType[]|ArrayCollection
     */
    public function getUserAttributeType()
    {
        return $this->userAttributeType;
    }

    /**
     * @param UserAttributeType $attributeType
     * @return Request
     */
    public function addUserAttributeType(UserAttributeType $attributeType)
    {
        if (!$this->userAttributeType->contains($attributeType)) {
            $this->userAttributeType->add($attributeType);
        }

        return $this;
    }
}
