<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Request\UserWs\Version1\UserApplicationRole\Add;

use JMS\Serializer\Annotation as Serializer;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class RoleType
 *
 * @Serializer\XmlRoot("roleType")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Request\UserWs\Version1\UserApplicationRole\Add
 */
class RoleType
{
    /**
     * @Serializer\SerializedName("name")
     * @Serializer\Type("string")
     *
     * @Assert\NotBlank
     *
     * @var string
     */
    private $name;

    /**
     * @Serializer\SerializedName("active")
     * @Serializer\Type("integer")
     *
     * @Assert\NotBlank
     *
     * @var integer
     */
    private $active;

    /**
     * @Serializer\SerializedName("userType")
     * @Serializer\Type("Sso\RestBundle\ModelRest\Request\UserWs\Version1\UserApplicationRole\Delete\UserType")
     *
     * @Assert\NotBlank
     *
     * @var UserType
     */
    private $userType;

    /**
     * @Serializer\SerializedName("applicationType")
     * @Serializer\Type("Sso\RestBundle\ModelRest\Request\UserWs\Version1\UserApplicationRole\Delete\ApplicationType")
     *
     * @Assert\NotBlank
     *
     * @var ApplicationType
     */
    private $applicationType;

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return integer
     */
    public function getActive()
    {
        return $this->active;
    }

    /**
     * @param integer $active
     *
     * @return RoleType
     */
    public function setActive($active)
    {
        $this->active = $active;

        return $this;
    }

    /**
     * @return UserType
     */
    public function getUserType()
    {
        return $this->userType;
    }

    /**
     * @param UserType $userType
     * @return $this
     */
    public function setUserType($userType)
    {
        $this->userType = $userType;

        return $this;
    }

    /**
     * @return ApplicationType
     */
    public function getApplicationType()
    {
        return $this->applicationType;
    }

    /**
     * @param ApplicationType $applicationType
     * @return $this
     */
    public function setApplicationType($applicationType)
    {
        $this->applicationType = $applicationType;

        return $this;
    }
}
