<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Request\UserWs\Version1\UserService;

/**
 * Class Factory
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Request\UserWs\Version1\UserService
 */
class Factory
{
    /**
     * @return ActivateRequest\Request
     */
    public function activateRequest()
    {
        return new ActivateRequest\Request();
    }

    /**
     * @return ActivateConfirm\Request
     */
    public function activateConfirm()
    {
        return new ActivateConfirm\Request();
    }

    /**
     * @return PasswordRequest\Request
     */
    public function passwordRequest()
    {
        return new PasswordRequest\Request();
    }

    /**
     * @return PasswordConfirm\Request
     */
    public function passwordConfirm()
    {
        return new PasswordConfirm\Request();
    }
}
