<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Request\UserWs\Version1\UserService\PasswordConfirm;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class UserPasswordConfirm
 *
 * @Serializer\XmlRoot("userPasswordConfirm")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Request\UserWs\Version1\UserService\PasswordConfirm
 */
class UserPasswordConfirm
{
    /**
     * @Serializer\SerializedName("userType")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Request\UserWs\Version1\UserService\PasswordConfirm\UserType>")
     * @Serializer\XmlList(inline=true, entry="userType")
     *
     * @var UserType[]|ArrayCollection
     */
    private $userType;

    /**
     * @return UserType[]|ArrayCollection
     */
    public function getUserType()
    {
        return $this->userType;
    }

    /**
     * @param UserType $userType
     */
    public function addUserType(UserType $userType)
    {
        if (!$this->userType) {
            $this->userType = new ArrayCollection();
        }

        if (!$this->userType->contains($userType)) {
            $this->userType->add($userType);
        }
    }
}
