<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Request\UserWs\Version1\UserService\PasswordRequest;

use JMS\Serializer\Annotation as Serializer;

/**
 * @Serializer\XmlRoot("userServicePasswordRequest")
 *
 * Class Request
 * @package Sso\RestBundle\ModelRest\Request\UserWs\Version1\UserService\PasswordRequest
 */
class Request
{
    /**
     * @Serializer\SerializedName("userPasswordRequest")
     * @Serializer\Type("Sso\RestBundle\ModelRest\Request\UserWs\Version1\UserService\PasswordRequest\UserPasswordRequest")
     *
     * @var UserPasswordRequest
     */
    private $userPasswordRequest;

    /**
     * @return UserPasswordRequest
     */
    public function getUserPasswordRequest()
    {
        return $this->userPasswordRequest;
    }

    /**
     * @param UserPasswordRequest $userPasswordRequest
     * @return Request
     */
    public function setUserPasswordRequest(UserPasswordRequest $userPasswordRequest)
    {
        $this->userPasswordRequest = $userPasswordRequest;

        return $this;
    }
}
