<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Request\UserWs\Version2\User\Add;

use Sso\RestBundle\ModelRest\Common\Request\UserWs\UserTypeFields;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class UserType
 *
 * @Serializer\XmlRoot("UserType")
 * @Serializer\AccessorOrder("custom", custom={"email","username","firstName","lastName","password","active","authId","ldapSearchAttributes","ldapSearchValue","mfaEnabled"})
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Request\UserWs\Version2\User\Add
 */
class UserType
{
    use UserTypeFields;

    /**
     * @Serializer\SerializedName("mfaEnabled")
     * @Serializer\Type("integer")
     *
     * @var integer
     */
    private $mfaEnabled;

    /**
     * @return integer
     */
    public function getMfaEnabled()
    {
        return $this->mfaEnabled;
    }

    /**
     * @param integer $mfaEnabled
     * @return UserType
     */
    public function setMfaEnabled($mfaEnabled)
    {
        $this->mfaEnabled = $mfaEnabled;
        return $this;
    }
}
