<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Request\UserWs\Version2\User\Show;

use JMS\Serializer\Annotation as Serializer;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class Request
 * @package Sso\RestBundle\ModelRest\Request\UserWs\Version2\User\Show
 */
class Request
{
    /**
     * @Serializer\Type("array")
     * @Assert\NotBlank()
     * @var array
     */
    protected $identifiers;

    /**
     * @return array
     */
    public function getIdentifiers()
    {
        return $this->identifiers;
    }

    /**
     * @param $identifiers
     * @return $this
     */
    public function setIdentifiers($identifiers)
    {
        $this->identifiers = $identifiers;

        return $this;
    }

    /**
     * @param $identifier
     * @return $this
     */
    public function addIdentifier($identifier)
    {
        $this->identifiers[] = $identifier;

        return $this;
    }
}
