<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Request\UserWs\Version2\UserApplication\Show;

use JMS\Serializer\Annotation as Serializer;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class Request
 *
 * @Serializer\XmlRoot("userApplication")
 *
 * @package Sso\RestBundle\ModelRest\Request\UserWs\Version2\UserApplication\Show
 */
class Request
{
    /**
     * @Serializer\SerializedName("identifier")
     * @Serializer\Type("string")
     *
     * @Assert\NotBlank()
     *
     * @var string
     */
    private $identifier;

    /**
     * @Serializer\SerializedName("applicationActive")
     * @Serializer\Type("integer")
     *
     * @var integer|null
     */
    private $applicationActive;

    /**
     * @return string
     */
    public function getIdentifier()
    {
        return $this->identifier;
    }

    /**
     * @param string $identifier
     * @return Request
     */
    public function setIdentifier($identifier)
    {
        $this->identifier = $identifier;

        return $this;
    }

    /**
     * @return integer
     */
    public function getApplicationActive()
    {
        return $this->applicationActive;
    }

    /**
     * @param integer $applicationActive
     * @return Request
     */
    public function setApplicationActive($applicationActive)
    {
        $this->applicationActive = $applicationActive;

        return $this;
    }
}
