<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Request\UserWs\Version2\UserApplication\ShowDetails;

use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class Request
 * @package Sso\RestBundle\ModelRest\Request\UserWs\Version2\UserApplication\ShowDetails
 */
class Request
{
    /**
     * @Assert\NotBlank()
     * @var string
     */
    private $identifier;

    /**
     * @var array|null
     */
    private $appName = null;

    /**
     * @return string
     */
    public function getIdentifier()
    {
        return $this->identifier;
    }

    /**
     * @param string $identifier
     * @return Request
     */
    public function setIdentifier($identifier)
    {
        $this->identifier = $identifier;

        return $this;
    }

    /**
     * @return array
     */
    public function getAppNames()
    {
        return $this->appName;
    }

    /**
     * @param string $appName
     * @return Request
     */
    public function addAppNames($appName)
    {
        $this->appName[] = $appName;

        return $this;
    }

    /**
     * @param array $appName
     * @return Request
     */
    public function setAppName($appName)
    {
        $this->appName = $appName;

        return $this;
    }
}
