<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Request\UserWs\Version2\UserSearch\Advanced;

use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Component\Validator\Constraints as Assert;
use Sso\RestBundle\ModelShared\Request\UserWs\Version2\UserSearch\Advanced\Filters;

/**
 * @Serializer\XmlRoot("advancedSearch")
 *
 * Class Request
 * @package Sso\RestBundle\ModelRest\Request\UserWs\Version2\UserSearch\Advanced
 */
class AdvancedSearch
{
    /**
     * @Serializer\SerializedName("offset")
     * @Serializer\Type("integer")
     * @var integer
     */
    private $offset;

    /**
     * @Serializer\SerializedName("limit")
     * @Serializer\Type("integer")
     * @var integer
     */
    private $limit;

    /**
     * @Serializer\SerializedName("orderBy")
     * @Serializer\Type("string")
     * @var string
     */
    private $orderBy;

    /**
     * @Serializer\SerializedName("orderDir")
     * @Serializer\Type("string")
     * @var string
     */
    private $orderDir;

    /**
     * @Serializer\SerializedName("fullResponse")
     * @Serializer\Type("integer")
     * @var integer
     */
    private $fullResponse;

    /**
     * @Serializer\SerializedName("filters")
     * @Serializer\Type("Sso\RestBundle\ModelShared\Request\UserWs\Version2\UserSearch\Advanced\Filters")
     * @var Filters
     */
    private $filters;

    /**
     * @return integer
     */
    public function getOffset()
    {
        return $this->offset;
    }

    /**
     * @param integer $offset
     * @return AdvancedSearch
     */
    public function setOffset($offset)
    {
        $this->offset = $offset;

        return $this;
    }

    /**
     * @return integer
     */
    public function getLimit()
    {
        return $this->limit;
    }

    /**
     * @param integer $limit
     * @return AdvancedSearch
     */
    public function setLimit($limit)
    {
        $this->limit = $limit;

        return $this;
    }

    /**
     * @return string
     */
    public function getOrderBy()
    {
        return $this->orderBy;
    }

    /**
     * @param string $orderBy
     * @return AdvancedSearch
     */
    public function setOrderBy($orderBy)
    {
        $this->orderBy = $orderBy;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getOrderDir()
    {
        return $this->orderDir;
    }

    /**
     * @param mixed $orderDir
     * @return AdvancedSearch
     */
    public function setOrderDir($orderDir)
    {
        $this->orderDir = $orderDir;

        return $this;
    }

    /**
     * @return integer
     */
    public function getFullResponse()
    {
        return $this->fullResponse;
    }

    /**
     * @param mixed $fullResponse
     * @return AdvancedSearch
     */
    public function setFullResponse($fullResponse)
    {
        $this->fullResponse = $fullResponse;

        return $this;
    }

    /**
     * @return Filters
     */
    public function getFilters()
    {
        return $this->filters;
    }

    /**
     * @param Filters $filters
     * @return AdvancedSearch
     */
    public function setFilters($filters)
    {
        $this->filters = $filters;

        return $this;
    }
}
