<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Request\UserWs\Version2\UserSearch\Advanced;

use JMS\Serializer\Annotation as Serializer;

/**
 * @Serializer\XmlRoot("userSearchAdvanced")
 * Class Request
 * @package Sso\RestBundle\ModelRest\Request\UserWs\Version2\UserSearch\Advanced
 */
class Request
{
    /**
     * @Serializer\SerializedName("advancedSearch")
     * @Serializer\Type("Sso\RestBundle\ModelRest\Request\UserWs\Version2\UserSearch\Advanced\AdvancedSearch")
     *
     * @var AdvancedSearch
     */
    private $advancedSearch;

    /**
     * @return AdvancedSearch
     */
    public function getAdvancedSearch()
    {
        return $this->advancedSearch;
    }

    /**
     * @param AdvancedSearch $advancedSearch
     * @return Request
     */
    public function setAdvancedSearch(AdvancedSearch $advancedSearch)
    {
        $this->advancedSearch = $advancedSearch;

        return $this;
    }
}
