<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Request\UserWs\Version2\UserSearch\FindByApplicationAttribute;

use JMS\Serializer\Annotation as Serializer;

/**
 * @Serializer\XmlRoot("userByAttribute")
 * Class UserType
 * @package Sso\RestBundle\ModelRest\Request\UserWs\Version2\UserSearch\FindByApplicationAttribute
 */
class UserType
{
    /**
     * @Serializer\SerializedName("modified")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $modified;

    /**
     * @Serializer\SerializedName("applicationType")
     * @Serializer\Type("Sso\RestBundle\ModelRest\Request\UserWs\Version2\UserSearch\FindByApplicationAttribute\ApplicationType")
     *
     * @var ApplicationType
     */
    private $applicationType;

    /**
     * @Serializer\SerializedName("attributeType")
     * @Serializer\Type("Sso\RestBundle\ModelRest\Request\UserWs\Version2\UserSearch\FindByApplicationAttribute\AttributeType")
     *
     * @var AttributeType
     */
    private $attributeType;

    /**
     * @return string
     */
    public function getModified()
    {
        return $this->modified;
    }

    /**
     * @param string $modified
     * @return UserType
     */
    public function setModified($modified)
    {
        $this->modified = $modified;

        return $this;
    }

    /**
     * @return ApplicationType
     */
    public function getApplicationType()
    {
        return $this->applicationType;
    }

    /**
     * @param ApplicationType $applicationType
     * @return UserType
     */
    public function setApplicationType($applicationType)
    {
        $this->applicationType = $applicationType;

        return $this;
    }

    /**
     * @return AttributeType
     */
    public function getAttributeType()
    {
        return $this->attributeType;
    }

    /**
     * @param AttributeType $attributeType
     * @return UserType
     */
    public function setAttributeType($attributeType)
    {
        $this->attributeType = $attributeType;

        return $this;
    }
}
