<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Request\UserWs\Version2\UserSearch\FindByApplicationRole;

use JMS\Serializer\Annotation as Serializer;

/**
 *
 * @Serializer\XmlRoot("userSearchByRole")
 *
 * Class Request
 * @package Sso\RestBundle\ModelRest\Request\UserWs\Version2\UserSearch\FindByApplicationRole
 */
class Request
{
    /**
     * @Serializer\SerializedName("userByRole")
     * @Serializer\Type("Sso\RestBundle\ModelRest\Request\UserWs\Version2\UserSearch\FindByApplicationRole\UserByRole")
     *
     * @var UserByRole
     */
    private $userByRole;

    /**
     * @return UserByRole
     */
    public function getUserByRole()
    {
        return $this->userByRole;
    }

    /**
     * @param UserByRole $userByRole
     * @return Request
     */
    public function setUserByRole(UserByRole $userByRole)
    {
        $this->userByRole = $userByRole;

        return $this;
    }
}
