<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\IdpWs\ServiceUser;

/**
 * Class Factory
 * @package Sso\RestBundle\ModelRest\Response\IdpWs\ServiceUser
 */
class Factory
{
    /**
     * @var array
     */
    protected $facSetter;

    /**
     * @return Get\UserIdentifier
     */
    public function get()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Get\UserIdentifier();
        }

        return $this->facSetter[__FUNCTION__];
    }

    /**
     * @return Validate\UserIdentifier
     */
    public function validate()
    {
        if (!isset($this->facSetter[__FUNCTION__])) {
            $this->facSetter[__FUNCTION__] = new Validate\UserIdentifier();
        }

        return $this->facSetter[__FUNCTION__];
    }
}
