<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\MultipleWs\Version1\Object\Scope\Tree\Success;

use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;
use Sso\RestBundle\Api\Helper\Mapper\Index as Mapper;

/**
 * Class ObjectType
 *
 * @Serializer\XmlRoot("show")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\MultipleWs\Version1\Object\Scope\Tree\Success
 */
class ObjectType
{
    /**
     * @Serializer\SerializedName("typeName")
     * @Serializer\Type("string")
     * @var string
     */
    private $typeName;

    /**
     * @Serializer\SerializedName("guid")
     * @Serializer\Type("string")
     * @var string
     */
    private $guid;

    /**
     * @Serializer\SerializedName("referenceId")
     * @Serializer\Type("string")
     * @var string
     */
    private $referenceId;

    /**
     * @Serializer\SerializedName("name")
     * @Serializer\Type("string")
     * @var string
     */
    private $name;

    /**
     * @Serializer\SerializedName("treeId")
     * @Serializer\Type("string")
     * @var string
     */
    private $treeId;

    /**
     * @Serializer\SerializedName("scopeType")
     * @Serializer\Type("string")
     * @var string
     */
    private $scopeType;

    /**
     * @return string
     */
    public function getGuid()
    {
        return $this->guid;
    }

    /**
     * @return string
     */
    public function getReferenceId()
    {
        return $this->referenceId;
    }

    /**
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @return string
     */
    public function getTypeName()
    {
        return $this->typeName;
    }

    /**
     * @param string $guid
     */
    public function setGuid($guid)
    {
        $this->guid = $guid;
    }

    /**
     * @param string $referenceId
     * @return ObjectType
     */
    public function setReferenceId($referenceId)
    {
        $this->referenceId = $referenceId;

        return $this;
    }

    /**
     * @param string $typeName
     * @return ObjectType
     */
    public function setTypeName($typeName)
    {
        $this->typeName = $typeName;
        return $this;
    }

    /**
     * @param string $name
     */
    public function setName($name)
    {
        $this->name = $name;
    }

    /**
     * @return string
     */
    public function getTreeId()
    {
        return $this->treeId;
    }

    /**
     * @param string $treeId
     * @return ObjectType
     */
    public function setTreeId($treeId)
    {
        $this->treeId = $treeId;
        return $this;
    }

    /**
     * @return string
     */
    public function getScopeType()
    {
        return $this->scopeType;
    }

    /**
     * @param string $scopeType
     * @return ObjectType
     */
    public function setScopeType($scopeType)
    {
        $this->scopeType = $scopeType;
        return $this;
    }
}
