<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\Attribute\Add;

use Sso\RestBundle\ModelRest\Common\Response\UserWs\ErrorCollector\Error;
use Sso\RestBundle\ModelRest\Response\Common\ResponseHead;
use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class Attribute
 *
 * @Serializer\XmlRoot("attributes")
 * @Serializer\AccessorOrder("custom", custom={"code","status"})
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\Attribute\Add
 */
class Attribute
{
    use ResponseHead;

    /**
     * @Serializer\SerializedName("id")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $attributeId;

    /**
     * @Serializer\SerializedName("name")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $attributeName;

    /**
     * @Serializer\SerializedName("mandatory")
     * @Serializer\Type("integer")
     *
     * @var int
     */
    private $attributeMandatory;

    /**
     * @Serializer\SerializedName("possibleValues")
     * @Serializer\Type("ArrayCollection<string>")
     * @Serializer\XmlList(entry="value")
     *
     * @var ArrayCollection|string[]
     */
    private $attributePossibleValues;

    /**
     * @Serializer\SerializedName("defaultValue")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $attributeDefaultValue;

    /**
     * @Serializer\SerializedName("translatable")
     * @Serializer\Type("integer")
     *
     * @var int
     */
    private $attributeTranslatable;

    /**
     * @Serializer\SerializedName("groupId")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $attributeGroupId;

    /**
     * @Serializer\SerializedName("errors")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Common\Response\UserWs\ErrorCollector\Error>")
     * @Serializer\XmlList(entry="error")
     *
     * @var Error[]|ArrayCollection
     */
    private $errors;

    /**
     * @return string
     */
    public function getAttributeId()
    {
        return $this->attributeId;
    }

    /**
     * @param string $attributeId
     * @return Attribute
     */
    public function setAttributeId($attributeId)
    {
        $this->attributeId = $attributeId;
        return $this;
    }

    /**
     * @return string
     */
    public function getAttributeName()
    {
        return $this->attributeName;
    }

    /**
     * @param string $attributeName
     * @return Attribute
     */
    public function setAttributeName($attributeName)
    {
        $this->attributeName = $attributeName;
        return $this;
    }

    /**
     * @return int
     */
    public function getAttributeMandatory()
    {
        return $this->attributeMandatory;
    }

    /**
     * @param int $attributeMandatory
     * @return Attribute
     */
    public function setAttributeMandatory($attributeMandatory)
    {
        $this->attributeMandatory = $attributeMandatory;
        return $this;
    }

    /**
     * @return ArrayCollection|string[]
     */
    public function getAttributePossibleValues()
    {
        return $this->attributePossibleValues;
    }

    /**
     * @param ArrayCollection|string[] $attributePossibleValues
     * @return Attribute
     */
    public function setAttributePossibleValues($attributePossibleValues)
    {
        $this->attributePossibleValues = new ArrayCollection($attributePossibleValues);
        return $this;
    }

    /**
     * @return string
     */
    public function getAttributeDefaultValue()
    {
        return $this->attributeDefaultValue;
    }

    /**
     * @param string $attributeDefaultValue
     * @return Attribute
     */
    public function setAttributeDefaultValue($attributeDefaultValue)
    {
        $this->attributeDefaultValue = $attributeDefaultValue;
        return $this;
    }

    /**
     * @return int
     */
    public function getAttributeTranslatable()
    {
        return $this->attributeTranslatable;
    }

    /**
     * @param int $attributeTranslatable
     * @return Attribute
     */
    public function setAttributeTranslatable($attributeTranslatable)
    {
        $this->attributeTranslatable = $attributeTranslatable;
        return $this;
    }

    /**
     * @return string
     */
    public function getAttributeGroupId()
    {
        return $this->attributeGroupId;
    }

    /**
     * @param string $attributeGroupId
     * @return Attribute
     */
    public function setAttributeGroupId($attributeGroupId)
    {
        $this->attributeGroupId = $attributeGroupId;
        return $this;
    }

    /**
     * @return Error[]|ArrayCollection
     */
    public function getErrors()
    {
        return $this->errors;
    }

    /**
     * @param Error $error
     * @return Attribute
     */
    public function setError(Error $error)
    {
        // Prevent empty error array in success response
        if (!$this->errors) {
            $this->errors = new ArrayCollection();
        }

        if (!$this->errors->contains($error)) {
            $this->errors->add($error);
        }

        return $this;
    }
}
