<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\Attribute\Delete;

use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class Response
 *
 * @Serializer\XmlRoot("attribute")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\Attribute\Delete
 */
class Response
{
    /**
     * @Serializer\SerializedName("attribute")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\Attribute\Delete\Item>")
     * @Serializer\XmlList(entry="item")
     *
     * @Assert\All({
     *     @Assert\NotBlank
     * })
     *
     * @var Item[]
     */
    protected $item;

    /**
     * Response constructor.
     */
    public function __construct()
    {
        $this->item = new ArrayCollection();
    }

    /**
     * @return Item[]
     */
    public function getItem()
    {
        return $this->item;
    }

    /**
     * @param Item $item
     */
    public function addItem(Item $item)
    {
        $this->item[] = $item;
    }
}
