<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\AttributeGroup\Add;

use Sso\RestBundle\ModelRest\Response\Common\ResponseHead;
use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * Class Response
 *
 * @Serializer\XmlRoot("attributeGroupAdd")
 * @Serializer\AccessorOrder("custom", custom = {"code", "status", "trackId", "date", "scriptTimeSec"})
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\AttributeGroup\Add
 */
class Response
{
    use ResponseHead;

    /**
     * @Serializer\SerializedName("attributeGroup")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\AttributeGroup\Add\AttributeGroupType>")
     * @Serializer\XmlList(entry="attributeType")
     *
     * @var AttributeGroupType[]|ArrayCollection
     */
    private $attributeGroupType;

    /**
     * Response constructor.
     */
    public function __construct()
    {
        $this->attributeGroupType = new ArrayCollection();
    }

    /**
     * @return AttributeGroupType[]|ArrayCollection
     */
    public function getAttributeGroupType()
    {
        return $this->attributeGroupType;
    }

    /**
     * @param AttributeGroupType $attributeGroupType
     */
    public function addAttributeGroupType(AttributeGroupType $attributeGroupType)
    {
        if (!$this->attributeGroupType->contains($attributeGroupType)) {
            $this->attributeGroupType->add($attributeGroupType);
        }
    }
}
