<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\AttributeGroup\Delete;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class Errors
 *
 * @Serializer\XmlRoot("response")
 * @Serializer\ExclusionPolicy("all")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\AttributeGroup\Delete
 */
class Errors
{
    /**
     * @var string
     *
     * Serializer Mapping
     * @Serializer\Expose
     * @Serializer\SerializedName("status")
     */
    private $status;

    /**
     * @Serializer\SerializedName("code")
     * @Serializer\Type("integer")
     *
     * @var integer
     */
    protected $code;

    /**
     * @Serializer\SerializedName("scriptSeconds")
     * @Serializer\Type("double")
     *
     * @var double
     */
    protected $scriptSeconds;

    /**
     * @var string
     *
     * Serializer Mapping
     * @Serializer\Expose
     * @Serializer\SerializedName("message")
     */
    private $message;

    /**
     * @var string
     *
     * Serializer Mapping
     * @Serializer\Expose
     * @Serializer\SerializedName("trackid")
     */
    private $trackId;

    /**
     * @var string
     *
     * Serializer Mapping
     * @Serializer\Expose
     * @Serializer\SerializedName("count")
     */
    private $count;

    /**
     *
     * Serializer Mapping
     * @Serializer\Expose
     * @Serializer\SerializedName("errors")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\AttributeGroup\Delete\Error>")
     * @Serializer\XmlList(entry="error")
     *
     * Define Var Type
     * @var ArrayCollection
     */
    private $errors;

    /**
     * @var array
     */
    private $statusMessages;

    /**
     * Errors constructor.
     */
    public function __construct()
    {
        $this->errors = new ArrayCollection();
        $this->count = 0;
        $this->statusMessages = [
            200 => 'OK',
            204 => 'No Content',
            400 => 'Bad Request',
            401 => 'Forbidden',
            500 => 'Internal Server Error',
        ];
    }

    /**
     * @param integer $status
     */
    public function setStatus($status)
    {
        $this->status = (int)$status;
        if (isset($this->statusMessages[$status])) {
            $this->message = $this->statusMessages[$status];
        } else {
            $this->message = 'Not Found';
        }
    }

    /**
     * @return integer
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * count + 1
     */
    public function addCount()
    {
        $this->count++;
    }

    /**
     * count - 1
     */
    public function removeCount()
    {
        $this->count--;
    }

    /**
     * @param Error $error
     * @return Errors
     */
    public function addError(Error $error)
    {
        $this->errors[] = $error;
        $this->addCount();

        return $this;
    }

    /**
     * @param Error $error
     */
    public function removeError(Error $error)
    {
        $this->errors->removeElement($error);
        $this->removeCount();
    }

    /**
     * Get Errors
     *
     * @return Error[]
     */
    public function getError()
    {
        return $this->errors;
    }

    /**
     * @return boolean
     */
    public function hasErrors()
    {
        return 0 < $this->count;
    }

    /**
     * @return integer
     */
    public function getErrorsCount()
    {
        return $this->count;
    }

    /**
     * @return string
     */
    public function getMessage()
    {
        return $this->message;
    }

    /**
     * @param string $trackId
     */
    public function setTrackId($trackId)
    {
        $this->trackId = $trackId;
    }

    /**
     * @return string
     */
    public function getTrackId()
    {
        return $this->trackId;
    }


    /**
     * @return integer
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @param integer $code
     */
    public function setCode($code)
    {
        $this->code = $code;
    }


    /**
     * @return double
     */
    public function getScriptSeconds()
    {
        return $this->scriptSeconds;
    }

    /**
     * @param double $scriptSeconds
     */
    public function setScriptSeconds($scriptSeconds)
    {
        $this->scriptSeconds = $scriptSeconds;
    }
}
