<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\AttributeGroup\Delete;

use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class Response
 *
 * @Serializer\XmlRoot("attributeGroup")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\AttributeGroup\Delete
 */
class Response
{
    /**
     * @Serializer\SerializedName("status")
     * @Serializer\Type("string")
     * @Serializer\XmlList(entry="status")
     * @var string
     */
    protected $status;

    /**
     * @Serializer\SerializedName("code")
     * @Serializer\Type("integer")
     * @var integer
     */
    protected $code;

    /**
     * @Serializer\SerializedName("message")
     * @Serializer\Type("string")
     * @var string
     */
    protected $message;

    /**
     * @Serializer\SerializedName("trackId")
     * @Serializer\Type("string")
     * @var string
     */
    protected $trackId;

    /**
     * @Serializer\SerializedName("scriptSeconds")
     * @Serializer\Type("double")
     * @var double
     */
    protected $scriptSeconds;

    /**
     * @Serializer\SerializedName("attributeGroup")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\AttributeGroup\Delete\Item>")
     * @Serializer\XmlList(entry="item")
     *
     * @Assert\All({
     *     @Assert\NotBlank
     * })
     * @var Item[]
     */
    protected $item;

    /**
     * Response constructor.
     */
    public function __construct()
    {
        $this->item = new ArrayCollection();
        $this->statusMessages = [
            200 => 'OK',
            204 => 'No Content',
            400 => 'Bad Request',
            401 => 'Forbidden',
            500 => 'Internal Server Error',
        ];
    }

    /**
     * @return mixed
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @param mixed $status
     * @return Response
     */
    public function setStatus($status)
    {
        $this->status = (int)$status;
        if (isset($this->statusMessages[$status])) {
            $this->message = $this->statusMessages[$status];
        } else {
            $this->message = 'Not Found';
        }
        return $this;
    }

    /**
     * @return mixed
     */
    public function getMessage()
    {
        return $this->message;
    }


    /**
     * @return mixed
     */
    public function getTrackId()
    {
        return $this->trackId;
    }

    /**
     * @param mixed $trackId
     * @return Response
     */
    public function setTrackId($trackId)
    {
        $this->trackId = $trackId;
        return $this;
    }

    /**
     * @return double
     */
    public function getScriptSeconds()
    {
        return $this->scriptSeconds;
    }

    /**
     * @param double $scriptSeconds
     * @return Response
     */
    public function setScriptSeconds($scriptSeconds)
    {
        $this->scriptSeconds = $scriptSeconds;
        return $this;
    }

    /**
     * @return Item[]|ArrayCollection[]
     */
    public function getItem()
    {
        return $this->item;
    }

    /**
     * @param Item $item
     */
    public function addItem(Item $item)
    {
        $this->item[] = $item;
    }

    /**
     * @return integer
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @param integer $code
     * @return Response
     */
    public function setCode($code)
    {
        $this->code = $code;
        return $this;
    }
}
