<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\AttributeGroup\Show\Success;

use Sso\RestBundle\Api\Helper\Mapper\Index as Mapper;

/**
 * Class Factory
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\AttributeGroup\Show\Success
 */
class Factory
{
    /**
     * @var array
     */
    protected $facSetter;

    /**
     *
     * @return Response
     */
    public function response()
    {
        return new Response();
    }

    /**
     * @param Mapper $mapper
     * @return AttributeGroupType
     */
    public function attributeGroupType(Mapper $mapper)
    {
        return new AttributeGroupType($mapper);
    }
}
