<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\AttributeGroup\Show\Success;

use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class Response
 *
 * @Serializer\XmlRoot("SsoResponse")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\AttributeGroup\Show\Success
 */
class Response
{
    /**
     * @Serializer\SerializedName("status")
     * @Serializer\Type("string")
     * @var string
     */
    private $Status;

    /**
     * @Serializer\SerializedName("code")
     * @Serializer\Type("integer")
     * @var integer
     */
    private $code;

    /**
     * @Serializer\SerializedName("scriptSeconds")
     * @Serializer\Type("float")
     * @var string
     */
    private $scriptSeconds;

    /**
     * @Serializer\SerializedName("trackid")
     * @Serializer\Type("string")
     * @var string
     */
    private $Trackid;

    /**
     * @Serializer\SerializedName("date")
     * @Serializer\Type("DateTime")
     * @var string
     */
    private $Date;

    /**
     * @Serializer\SerializedName("count")
     * @Serializer\Type("string")
     * @var string
     */
    private $count;

    /**
     * @Serializer\SerializedName("offset")
     * @Serializer\Type("string")
     * @var int
     */
    private $offset;

    /**
     * @Serializer\SerializedName("limit")
     * @Serializer\Type("string")
     * @var int
     */
    private $limit;

    /**
     * @Serializer\SerializedName("attributeGroups")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\AttributeGroup\Show\Success\AttributeGroupType>")
     * @Serializer\XmlList(inline=true, entry="attributeGroups")
     * @var ArrayCollection
     */
    private $attributeGroups;

    /**
     * Response constructor.
     */
    public function __construct()
    {
        $this->attributeGroups = new ArrayCollection();
    }

    /**
     *
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }

    /**
     *
     * @return string
     */
    public function getTrackid()
    {
        return $this->Trackid;
    }

    /**
     *
     * @return datetime
     */
    public function getDate()
    {
        return $this->Date;
    }

    /**
     *
     * @param string $Status
     * @return Response
     */
    public function setStatus($Status)
    {
        $this->Status = $Status;

        return $this;
    }

    /**
     *
     * @param string $Trackid
     * @return Response
     */
    public function setTrackid($Trackid)
    {
        $this->Trackid = $Trackid;

        return $this;
    }

    /**
     *
     * @param string $Date
     * @return Response
     */
    public function setDate($Date)
    {
        $this->Date = $Date;

        return $this;
    }

    /**
     * @return string
     */
    public function getCount()
    {
        return $this->count;
    }

    /**
     * @param string $count
     * @return Response
     */
    public function setCount($count)
    {
        $this->count = $count;

        return $this;
    }

    /**
     * @return int
     */
    public function getOffset()
    {
        return $this->offset;
    }

    /**
     * @param int $offset
     * @return Response
     */
    public function setOffset($offset)
    {
        $this->offset = $offset;

        return $this;
    }

    /**
     * @return int
     */
    public function getLimit()
    {
        return $this->limit;
    }

    /**
     * @param int $limit
     * @return Response
     */
    public function setLimit($limit)
    {
        $this->limit = $limit;

        return $this;
    }

    /**
     * @param AttributeGroupType $attributeGroup
     * @return Response
     */
    public function addAttributeGroup(AttributeGroupType $attributeGroup)
    {
        $this->attributeGroups->add($attributeGroup);

        return $this;
    }

    /**
     * @return AttributeGroupType[]|ArrayCollection
     */
    public function getAttributeGroups()
    {
        return $this->attributeGroups;
    }

    /**
     * @param string $scriptSeconds
     * @return Response
     */
    public function setScriptSeconds($scriptSeconds)
    {
        $this->scriptSeconds = $scriptSeconds;

        return $this;
    }

    /**
     * @return int
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @param int $code
     * @return Response
     */
    public function setCode($code)
    {
        $this->code = $code;

        return $this;
    }
}
