<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\Object\Add;

use Sso\RestBundle\ModelRest\Response\Common\ResponseHead;
use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;
use Sso\RestBundle\ModelRest\Common\Response\UserWs\ErrorCollector\Error;

/**
 * Class Object
 *
 * @Serializer\XmlRoot("objects")
 * @Serializer\AccessorOrder("custom", custom={"code","status"})
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\Object\Add
 */
class Object
{
    use ResponseHead;

    /**
     * @Serializer\SerializedName("guid")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $guid;

    /**
     * @Serializer\SerializedName("referenceId")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $referenceId;

    /**
     * @Serializer\SerializedName("typeId")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $typeId;

    /**
     * @Serializer\SerializedName("parentGuid")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $parentGuid;

    /**
     * @Serializer\SerializedName("name")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $name;

    /**
     * @Serializer\SerializedName("created")
     * @Serializer\Type("DateTime")
     *
     * @var \DateTime
     */
    private $created;

    /**
     * @Serializer\SerializedName("updated")
     * @Serializer\Type("DateTime")
     *
     * @var \DateTime
     */
    private $updated;

    /**
     * @Serializer\SerializedName("active")
     * @Serializer\Type("integer")
     *
     * @var int
     */
    private $active;

    /**
     * @Serializer\SerializedName("errors")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Common\Response\UserWs\ErrorCollector\Error>")
     * @Serializer\XmlList(entry="error")
     *
     * @var Error[]|ArrayCollection
     */
    private $errors;

    /**
     * @return string
     */
    public function getGuid()
    {
        return $this->guid;
    }

    /**
     * @param string $guid
     * @return Object
     */
    public function setGuid($guid)
    {
        $this->guid = $guid;
        return $this;
    }

    /**
     * @return string
     */
    public function getReferenceId()
    {
        return $this->referenceId;
    }

    /**
     * @param string $referenceId
     * @return Object
     */
    public function setReferenceId($referenceId)
    {
        $this->referenceId = $referenceId;

        return $this;
    }

    /**
     * @return string
     */
    public function getTypeId()
    {
        return $this->typeId;
    }

    /**
     * @param string $typeId
     * @return Object
     */
    public function setTypeId($typeId)
    {
        $this->typeId = $typeId;

        return $this;
    }

    /**
     * @return string
     */
    public function getParentGuid()
    {
        return $this->parentGuid;
    }

    /**
     * @param string $parentGuid
     * @return Object
     */
    public function setParentGuid($parentGuid)
    {
        $this->parentGuid = $parentGuid;

        return $this;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return Object
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getCreated()
    {
        return $this->created;
    }

    /**
     * @param \DateTime $created
     * @return Object
     */
    public function setCreated($created)
    {
        $this->created = $created;

        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getUpdated()
    {
        return $this->updated;
    }

    /**
     * @param \DateTime $updated
     * @return Object
     */
    public function setUpdated($updated)
    {
        $this->updated = $updated;

        return $this;
    }

    /**
     * @return int
     */
    public function getActive()
    {
        return $this->active;
    }

    /**
     * @param int $active
     * @return Object
     */
    public function setActive($active)
    {
        $this->active = $active;

        return $this;
    }

    /**
     * @return Error[]|ArrayCollection
     */
    public function getErrors()
    {
        return $this->errors;
    }

    /**
     * @param Error $error
     * @return Object
     */
    public function setError(Error $error)
    {
        // Prevent empty error array in success response
        if (!$this->errors) {
            $this->errors = new ArrayCollection();
        }

        if (!$this->errors->contains($error)) {
            $this->errors->add($error);
        }

        return $this;
    }
}
