<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\Object\Show\Single\Success;

use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class Response
 *
 * @Serializer\XmlRoot("SsoResponse")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\Object\Show\Single\Success
 */
class Response
{
    /**
     * @Serializer\SerializedName("status")
     * @Serializer\Type("string")
     * @var string
     */
    private $status;

    /**
     * @Serializer\SerializedName("code")
     * @Serializer\Type("integer")
     * @var integer
     */
    private $code;

    /**
     * @Serializer\SerializedName("scriptTimeSec")
     * @Serializer\Type("double")
     * @var double
     */
    private $scriptTimeSec;

    /**
     * @Serializer\SerializedName("trackid")
     * @Serializer\Type("string")
     * @var string
     */
    private $trackid;

    /**
     * @Serializer\SerializedName("date")
     * @Serializer\Type("DateTime")
     * @var string
     */
    private $date;

    /**
     * @Serializer\SerializedName("count")
     * @Serializer\Type("string")
     * @var string
     */
    private $count;

    /**
     * @Serializer\SerializedName("offset")
     * @Serializer\Type("string")
     * @var int
     */
    private $offset;

    /**
     * @Serializer\SerializedName("limit")
     * @Serializer\Type("string")
     * @var int
     */
    private $limit;

    /**
     * @Serializer\SerializedName("objects")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\Object\Show\Single\Success\ObjectType>")
     * @Serializer\XmlList(inline=true, entry="objects")
     * @var ArrayCollection
     */
    private $objects;

    public function __construct()
    {
        $this->objects = new ArrayCollection();
    }

    /**
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @return string
     */
    public function getTrackid()
    {
        return $this->trackid;
    }

    /**
     * @return datetime
     */
    public function getDate()
    {
        return $this->date;
    }

    /**
     * @param string $Status
     * @return Response
     */
    public function setStatus($Status)
    {
        $this->status = $Status;

        return $this;
    }

    /**
     * @param string $Trackid
     * @return Response
     */
    public function setTrackid($Trackid)
    {
        $this->trackid = $Trackid;

        return $this;
    }

    /**
     * @param string $Date
     * @return Response
     */
    public function setDate($Date)
    {
        $this->date = $Date;

        return $this;
    }

    /**
     * @return string
     */
    public function getCount()
    {
        return $this->count;
    }

    /**
     * @param string $Count
     * @return Response
     */
    public function setCount($Count)
    {
        $this->count = $Count;

        return $this;
    }

    /**
     * @return int
     */
    public function getOffset()
    {
        return $this->offset;
    }

    /**
     * @param int $offset
     * @return Response
     */
    public function setOffset($offset)
    {
        $this->offset = $offset;

        return $this;
    }

    /**
     * @return int
     */
    public function getLimit()
    {
        return $this->limit;
    }

    /**
     * @param int $limit
     * @return Response
     */
    public function setLimit($limit)
    {
        $this->limit = $limit;

        return $this;
    }

    /**
     * @param ObjectType $object
     * @return Response
     */
    public function addObject(ObjectType $object)
    {
        $this->objects->add($object);

        return $this;
    }

    /**
     * @return ObjectType[]
     */
    public function getObjects()
    {
        return $this->objects;
    }


    /**
     * @return int
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @param int $Code
     */
    public function setCode($Code)
    {
        $this->code = $Code;
    }

    /**
     * @return float
     */
    public function getScriptTimeSec()
    {
        return $this->scriptTimeSec;
    }

    /**
     * @param float $ScriptTimeSec
     */
    public function setScriptTimeSec($ScriptTimeSec)
    {
        $this->scriptTimeSec = $ScriptTimeSec;
    }
}
