<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\ObjectType\Add;

use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @Serializer\XmlRoot("objectType")
 */
class Response
{
    /**
     * @Serializer\SerializedName("objectType")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\ObjectType\Add\Item>")
     * @Serializer\XmlList(entry="item")
     *
     * @Assert\All({
     *     @Assert\NotBlank
     * })
     * @var Item
     */
    protected $item;

    public function __construct()
    {
        $this->item = new ArrayCollection();
    }

    /**
     * @return Item[]
     */
    public function getItem()
    {
        return $this->item;
    }

    /**
     * @param Item $item
     */
    public function addItem(Item $item)
    {
        $this->item[] = $item;
    }
}
