<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\ObjectType\Show\Success;

use Sso\RestBundle\ModelRest\Response\Common\ResponseHead;
use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * Class Response
 *
 * @Serializer\XmlRoot("objectType")
 * @Serializer\AccessorOrder("custom", custom = {"code", "status", "trackId", "date", "scriptTimeSec"})
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\ObjectType\Show\Success
 */
class Response
{
    use ResponseHead;

    /**
     * @Serializer\SerializedName("count")
     * @Serializer\Type("string")
     *
     * @var int
     */
    private $count;

    /**
     * @Serializer\SerializedName("offset")
     * @Serializer\Type("string")
     *
     * @var int
     */
    private $offset;

    /**
     * @Serializer\SerializedName("limit")
     * @Serializer\Type("string")
     *
     * @var int
     */
    private $limit;

    /**
     * @Serializer\SerializedName("types")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\ObjectType\Show\Success\TypeType>")
     * @Serializer\XmlList(inline=true, entry="type")
     *
     * @var TypeType[]|ArrayCollection
     */
    private $types;

    /**
     * Response constructor.
     */
    public function __construct()
    {
        $this->types = new ArrayCollection();
    }

    /**
     * @return int
     */
    public function getCount()
    {
        return $this->count;
    }

    /**
     * @param int $count
     * @return Response
     */
    public function setCount($count)
    {
        $this->count = $count;
        return $this;
    }

    /**
     * @return int
     */
    public function getOffset()
    {
        return $this->offset;
    }

    /**
     * @param int $offset
     * @return Response
     */
    public function setOffset($offset)
    {
        $this->offset = $offset;
        return $this;
    }

    /**
     * @return int
     */
    public function getLimit()
    {
        return $this->limit;
    }

    /**
     * @param int $limit
     * @return Response
     */
    public function setLimit($limit)
    {
        $this->limit = $limit;
        return $this;
    }

    /**
     * @return TypeType[]|ArrayCollection
     */
    public function getType()
    {
        return $this->types;
    }

    /**
     * @param TypeType $type
     */
    public function addType(TypeType $type)
    {
        if (!$this->types->contains($type)) {
            $this->types->add($type);
        }
    }
}
