<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\ObjectType\Show\Success;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class TypeType
 *
 * @Serializer\XmlRoot("types")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\ObjectType\Show\Success
 */
class TypeType
{
    /**
     * @Serializer\SerializedName("id")
     * @Serializer\Type("string")
     * @var string
     */
    private $id;

    /**
     * @Serializer\SerializedName("name")
     * @Serializer\Type("string")
     * @var string
     */
    private $name;

    /**
     * @Serializer\SerializedName("order")
     * @Serializer\Type("string")
     * @var string
     */
    private $order;

    /**
     * @Serializer\SerializedName("attributeGroups")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\ObjectType\Show\Success\AttributeGroup>")
     * @Serializer\XmlList(entry="attributeGroup")
     *
     * @var AttributeGroup[]|ArrayCollection
     */
    private $attributeGroups;

    /**
     * @Serializer\SerializedName("created")
     * @Serializer\Type("DateTime")
     * @var string
     */
    private $created;

    /**
     * @Serializer\SerializedName("updated")
     * @Serializer\Type("DateTime")
     * @var string
     */
    private $updated;

    /**
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param string $id
     * @return TypeType
     */
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return TypeType
     */
    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return string
     */
    public function getOrder()
    {
        return $this->order;
    }

    /**
     * @param string $order
     * @return TypeType
     */
    public function setOrder($order)
    {
        $this->order = $order;
        return $this;
    }

    /**
     * @return AttributeGroup[]|ArrayCollection
     */
    public function getAttributeGroups()
    {
        return $this->attributeGroups;
    }

    /**
     * @param AttributeGroup $attributeGroup
     * @return TypeType
     */
    public function setAttributeGroup(AttributeGroup $attributeGroup)
    {
        if (!$this->attributeGroups) {
            $this->attributeGroups = new ArrayCollection();
        }

        if (!$this->attributeGroups->contains($attributeGroup)) {
            $this->attributeGroups->add($attributeGroup);
        }

        return $this;
    }

    /**
     * @param $attributeGroups
     * @return TypeType
     */
    public function setAttributeGroups($attributeGroups)
    {
        $restAttributeGroups = new ArrayCollection();

        foreach ($attributeGroups as $attributeGroup) {
            $restAttributeGroup = new AttributeGroup();
            $restAttributeGroup
                ->setId($attributeGroup->getId())
                ->setName($attributeGroup->getName())
                ->setCreated($attributeGroup->getCreated())
                ->setUpdated($attributeGroup->getUpdated());

            $reqAttributes = $attributeGroup->getAttributes();
            if (!empty($reqAttributes) && !$reqAttributes->isEmpty()) {
                foreach ($attributeGroup->getAttributes() as $attribute) {
                    $restAttribute = new AttributeType();
                    $restAttribute
                        ->setId($attribute->getId())
                        ->setName($attribute->getName())
                        ->setMandatory($attribute->getMandatory())
                        ->setPossibleValues($attribute->getPossibleValues())
                        ->setDefaultValue($attribute->getDefaultValue())
                        ->setTranslatable($attribute->getTranslatable());

                    $restAttributeGroup->setAttributeType($restAttribute);
                }
            }

            $restAttributeGroups->add($restAttributeGroup);
        }

        if (!$restAttributeGroups->isEmpty()) {
            $this->attributeGroups = $restAttributeGroups;
        }

        return $this;
    }

    /**
     * @return string
     */
    public function getCreated()
    {
        return $this->created;
    }

    /**
     * @param string $created
     * @return TypeType
     */
    public function setCreated($created)
    {
        $this->created = $created;
        return $this;
    }

    /**
     * @return string
     */
    public function getUpdated()
    {
        return $this->updated;
    }

    /**
     * @param string $updated
     * @return TypeType
     */
    public function setUpdated($updated)
    {
        $this->updated = $updated;
        return $this;
    }
}
