<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\ObjectType\Update;

use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Class Item
 *
 * @Serializer\XmlRoot("item")
 * @package Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\ObjectType\Update
 */
class Item
{
    /**
     * @Serializer\SerializedName("id")
     * @Serializer\Type("string")
     *
     * @Assert\NotBlank()
     * @var string
     */
    protected $id;

    /**
     * @Serializer\SerializedName("status")
     * @Serializer\Type("string")
     *
     * @Assert\NotBlank()
     * @var string
     */
    protected $status;

    /**
     * @Serializer\SerializedName("code")
     * @Serializer\Type("integer")
     *
     * @var integer
     */
    protected $code;

    /**
     * @Serializer\SerializedName("scriptTimeSec")
     * @Serializer\Type("double")
     *
     * @var double
     */
    protected $scriptTimeSec;

    /**
     * @Serializer\SerializedName("name")
     * @Serializer\Type("string")
     *
     * @Assert\NotBlank()
     * @var string
     */
    protected $name;

    /**
     * @Serializer\SerializedName("order")
     * @Serializer\Type("integer")
     *
     * @Assert\NotBlank()
     * @var int
     */
    protected $order;

    /**
     * @Serializer\SerializedName("created")
     * @Serializer\Type("DateTime")
     *
     * @Assert\NotBlank()
     * @var \DateTime
     */
    protected $created;

    /**
     * @Serializer\SerializedName("updated")
     * @Serializer\Type("DateTime")
     *
     * @Assert\NotBlank()
     * @var \DateTime
     */
    protected $updated;

    /**
     * @Serializer\SerializedName("error")
     * @Serializer\Type("Sso\RestBundle\ModelRest\Response\ObjectWs\Version1\ObjectType\Update\Errors")
     * @Serializer\XmlList(entry="error")
     *
     * @var Errors
     */
    protected $errors;

    /**
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param string $id
     */
    public function setId($id)
    {
        $this->id = $id;
    }

    /**
     *
     * @return integer
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     *
     * @param integer $status
     */
    public function setStatus($status)
    {
        $this->status = $status;
    }

    /**
     *
     * @param string $name
     */
    public function setName($name)
    {
        $this->name = $name;
    }

    /**
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     *
     * @return Errors
     */
    public function getErrors()
    {
        return $this->errors;
    }

    /**
     *
     * @param Errors $errors
     */
    public function setErrors(Errors $errors)
    {
        $this->errors = $errors;
    }

    /**
     *
     * @return int
     */
    public function getOrder()
    {
        return $this->order;
    }

    /**
     *
     * @param int $order
     */
    public function setOrder($order)
    {
        $this->order = $order;
    }

    /**
     * @return \DateTime
     */
    public function getCreated()
    {
        return $this->created;
    }

    /**
     * @param \DateTime $created
     */
    public function setCreated(\DateTime $created)
    {
        $this->created = $created;
    }

    /**
     * @return \DateTime
     */
    public function getUpdated()
    {
        return $this->updated;
    }

    /**
     * @param \DateTime $updated
     */
    public function setUpdated(\DateTime $updated)
    {
        $this->updated = $updated;
    }

    /**
     * @return mixed
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @param mixed $code
     */
    public function setCode($code)
    {
        $this->code = $code;
    }

    /**
     * @return float
     */
    public function getScriptTimeSec()
    {
        return $this->scriptTimeSec;
    }

    /**
     * @param float $scriptTimeSec
     */
    public function setScriptTimeSec($scriptTimeSec)
    {
        $this->scriptTimeSec = $scriptTimeSec;
    }
}
