<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\RestBundle\ModelRest\Response\UserWs\Version1\Application\Delete;

use Sso\RestBundle\ModelRest\Response\Common\ResponseHead;
use JMS\Serializer\Annotation as Serializer;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * Class Response
 *
 * @Serializer\XmlRoot("applicationDelete")
 * @Serializer\AccessorOrder("custom", custom = {"code", "status", "trackId", "date", "scriptTimeSec"})
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\RestBundle\ModelRest\Response\UserWs\Version1\Application\Delete
 */
class Response
{
    use ResponseHead;

    /**
     * @Serializer\SerializedName("applications")
     * @Serializer\Type("ArrayCollection<Sso\RestBundle\ModelRest\Response\UserWs\Version1\Application\Delete\Application>")
     * @Serializer\XmlList(entry="application")
     *
     * @var Application[]|ArrayCollection
     */
    private $application;

    /**
     * @return Application[]|ArrayCollection
     */
    public function getApplication()
    {
        return $this->application;
    }

    /**
     * @param Application $application
     * @return Response
     */
    public function setApplication(Application $application)
    {
        if (!$this->application) {
            $this->application = new ArrayCollection();
        }

        if (!$this->application->contains($application)) {
            $this->application->add($application);
        }

        return $this;
    }
}
